/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui;

import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.Messages;
import com.aptana.ui.util.UIUtils;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.FeatureEvent;
import com.aptana.usage.IStudioAnalytics;
import com.aptana.usage.UsagePlugin;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;

public class PerspectiveChangeResetListener
extends PerspectiveAdapter {
    private static final String PERSPECTIVE_ACTIVATE_EVENT = "perspective.activate.{0}";
    private String pluginId;
    private String preferenceId;
    private String perspectiveId;
    private int perspectiveVersion;

    public PerspectiveChangeResetListener(String perspectiveId, String pluginId, String preferenceId, int perspectiveVersion) {
        this.perspectiveId = perspectiveId;
        this.pluginId = pluginId;
        this.preferenceId = preferenceId;
        this.perspectiveVersion = perspectiveVersion;
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        String perspectiveId;
        int version;
        if (this.perspectiveId != null && perspective != null && this.perspectiveId.equals(perspective.getId()) && this.perspectiveVersion > (version = Platform.getPreferencesService().getInt(this.pluginId, this.preferenceId, 0, null))) {
            this.resetPerspective(page);
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(this.pluginId);
            prefs.putInt(this.preferenceId, this.perspectiveVersion);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        if (perspective != null && !StringUtil.isEmpty((String)(perspectiveId = perspective.getId()))) {
            int index = perspectiveId.lastIndexOf(".");
            if (index > -1) {
                perspectiveId = perspectiveId.substring(index + 1);
            }
            this.sendEvent((AnalyticsEvent)new FeatureEvent(MessageFormat.format(PERSPECTIVE_ACTIVATE_EVENT, perspectiveId), null));
        }
    }

    private void sendEvent(AnalyticsEvent featureEvent) {
        UsagePlugin plugin = UsagePlugin.getDefault();
        if (plugin == null) {
            return;
        }
        IStudioAnalytics analytics = plugin.getStudioAnalytics();
        if (analytics == null) {
            return;
        }
        analytics.sendEvent(featureEvent);
    }

    private void resetPerspective(final IWorkbenchPage page) {
        UIJob job = new UIJob("Resetting Studio perspective..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (MessageDialog.openQuestion((Shell)UIUtils.getActiveShell(), (String)Messages.UIPlugin_ResetPerspective_Title, (String)Messages.UIPlugin_ResetPerspective_Description)) {
                    page.resetPerspective();
                }
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.setPriority(10);
        job.schedule();
    }
}

